package ru.yandex.intranet.d.web.model.delivery.provide

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import java.util.*

/**
 * Request DTO for delivery and provide operation
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */
@Schema(description = "Delivery and provide request.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class DeliveryAndProvideRequestDto @JsonCreator constructor(
    @get:Schema(description = "Delivery id.", required = true)
    val deliveryId: String?,
    @get:Schema(description = "Request author uid.", required = true)
    val authorUid: String?,
    @get:Schema(description = "Delivery destinations.", required = true)
    val deliverables: List<DeliveryAndProvideDestinationDto?>?
) {
    fun getDeliveryIdOptional() = Optional.ofNullable(deliveryId)
    fun getAuthorUidOptional() = Optional.ofNullable(authorUid)
    fun getDeliverablesOptional() = Optional.ofNullable(deliverables)

    data class Builder(var deliveryId: String? = null,
                       var authorUid: String? = null,
                       val deliverables: MutableList<DeliveryAndProvideDestinationDto> = mutableListOf()
    ) {
        fun deliveryId(deliveryId: String) = apply { this.deliveryId = deliveryId }
        fun authorUid(authorUid: String) = apply { this.authorUid = authorUid }
        fun addDeliverable(deliverable: DeliveryAndProvideDestinationDto) =
            apply { this.deliverables.add(deliverable) }
        fun addDeliverables(deliverables: Collection<DeliveryAndProvideDestinationDto>) =
            apply { this.deliverables.addAll(deliverables) }
        fun build() = DeliveryAndProvideRequestDto(deliveryId, authorUid, deliverables.toList())
    }
}
