package ru.yandex.intranet.d.web.model.delivery.status

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.web.model.resources.ResourceSegmentationSegmentDto

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
data class DeliveryStatusAccountDto(
    @get:Schema(description = "Account's id.", required = true)
    val accountId: String,

    @get:Schema(description = "Provider's id.", required = true)
    val providerId: String,

    @get:Schema(description = "Account's display name.", required = true)
    val displayName: String,

    @get:Schema(description = "Account's space segments (if supported).", required = false)
    val segments: Set<ResourceSegmentationSegmentDto>?,
)
