package ru.yandex.intranet.d.web.model.delivery.status

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

@JsonIgnoreProperties(ignoreUnknown = true)
data class DeliveryStatusDto(
    @get:Schema(description = "Delivery id.", required = true)
    val deliveryId: String,

    @get:Schema(description = "Operations referred to this delivery.", required = true)
    val operations: List<DeliveryStatusOperationDto>,

    @get:Schema(description = "Accounts referred to this delivery.", required = true)
    val accounts: List<DeliveryStatusAccountDto>,

    @get:Schema(description = "Providers referred to this delivery.", required = true)
    val providers: List<DeliveryStatusProviderDto>,

    @get:Schema(description = "Providers referred to this delivery.", required = true)
    val resources: List<DeliveryStatusResourceDto>
) {
    data class Builder(var deliveryId: String? = null,
                       var operations: MutableList<DeliveryStatusOperationDto> = mutableListOf(),
                       var accounts: MutableList<DeliveryStatusAccountDto> = mutableListOf(),
                       var providers: MutableList<DeliveryStatusProviderDto> = mutableListOf(),
                       var resources: MutableList<DeliveryStatusResourceDto> = mutableListOf()
    ) {
        fun deliveryId(deliveryId: String) = apply { this.deliveryId = deliveryId }
        fun addOperation(operation: DeliveryStatusOperationDto) =
            apply { this.operations.add(operation) }
        fun addOperations(operations: Collection<DeliveryStatusOperationDto>) =
            apply { this.operations.addAll(operations) }
        fun addAccount(account: DeliveryStatusAccountDto) =
            apply { this.accounts.add(account) }
        fun addAccounts(accounts: Collection<DeliveryStatusAccountDto>) =
            apply { this.accounts.addAll(accounts) }
        fun addProvider(provider: DeliveryStatusProviderDto) =
            apply { this.providers.add(provider) }
        fun addProviders(providers: Collection<DeliveryStatusProviderDto>) =
            apply { this.providers.addAll(providers) }
        fun addResource(resource: DeliveryStatusResourceDto) =
            apply { this.resources.add(resource) }
        fun addResources(resources: Collection<DeliveryStatusResourceDto>) =
            apply { this.resources.addAll(resources) }
        fun build() = DeliveryStatusDto(deliveryId!!, operations.toList(), accounts.toList(),
            providers.toList(), resources.toList())
    }
}
