package ru.yandex.intranet.d.web.model.delivery.status

import com.fasterxml.jackson.annotation.JsonFormat
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.model.accounts.OperationErrorKind
import ru.yandex.intranet.d.web.model.delivery.DeliverableFolderOperationDto
import ru.yandex.intranet.d.web.model.delivery.provide.DeliveryAndProvideMetaResponseDto
import ru.yandex.intranet.d.web.model.operations.OperationStatusDto
import java.time.Instant
import javax.annotation.Nullable

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
data class DeliveryStatusOperationDto(
    @get:Schema(description = "Operation id.", required = true)
    val operationId: String,

    @get:Schema(description = "Id of account delivery is being performed to.", required = false)
    @Nullable
    val accountId: String?,

    @get:Schema(description = "Provider's id.", required = true)
    val providerId: String,

    @get:Schema(description = "Requested quotas.", required = true)
    val requestedQuotas: List<DeliveryStatusRequestedQuotasDto>,

    @get:Schema(description = "Metadata.", required = false)
    val meta: DeliveryAndProvideMetaResponseDto?,

    @get:Schema(description = "Folder operation log id.", required = false)
    val folderOperationLogs: Set<DeliverableFolderOperationDto>?,

    @get:Schema(description = "Start of execution.", required = true)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timezone = "UTC")
    val createDateTime: Instant,

    @get:Schema(description = "Last update.", required = false)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timezone = "UTC")
    val updateDateTime: Instant?,

    @get:Schema(description = "Operation's status.", required = true)
    val status: OperationStatusDto,

    @get:Schema(description = "Error's message (if any occurs).", required = false)
    val errorMessage: String?,

    @get:Schema(description = "Operation error kind (if any occurs).", required = false)
    val errorKind: OperationErrorKind?
)
