package ru.yandex.intranet.d.web.model.delivery.status

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.web.model.resources.ResourceSegmentationSegmentDto

@JsonIgnoreProperties(ignoreUnknown = true)
data class DeliveryStatusResourceDto(
    @get:Schema(description = "Resource's id.", required = true)
    val resourceId: String,

    @get:Schema(description = "Resource's display name", required = true)
    val displayName: String,

    @get:Schema(description = "Resource's segments.", required = true)
    val segments: Set<ResourceSegmentationSegmentDto>
)
