package ru.yandex.intranet.d.web.model.dictionaries

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.kotlin.AccountsSpacesId
import ru.yandex.intranet.d.model.accounts.AccountModel
import ru.yandex.intranet.d.util.DisplayUtil

/**
 * Frontend account dictionary element DTO.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 16-02-2022
 */
@Schema(description = "Account.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class FrontAccountDictionaryElementDto @JsonCreator constructor(
    @get:[Schema(description = "Account.", required = true)]
    val name: String,

    @get:[Schema(description = "Folder ID for account.", required = true)]
    val folderId: String,

    @get:[Schema(description = "Account`s 'deleted' flag.", required = true)]
    val deleted: Boolean,

    @get:[Schema(description = "Account's space ID (if supported).", required = false)]
    val accountsSpacesId: AccountsSpacesId?
) {
    constructor(model: AccountModel) : this(
        name = DisplayUtil.getAccountDisplayString(model),
        folderId = model.folderId,
        deleted = model.isDeleted,
        accountsSpacesId = model.accountsSpacesId.orElse(null)
    )
}
