package ru.yandex.intranet.d.web.model.dictionaries

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.i18n.Locales
import ru.yandex.intranet.d.kotlin.SegmentId
import ru.yandex.intranet.d.kotlin.SegmentationId
import ru.yandex.intranet.d.model.accounts.AccountSpaceModel
import java.util.*

@Schema(description = "Accounts' space")
@JsonIgnoreProperties(ignoreUnknown = true)
data class FrontAccountsSpaceDictionaryElementDto @JsonCreator constructor(
    @get:Schema(description = "Accounts' space name")
    val name: String,

    @get:Schema(description = "Accounts' space segment IDs by segmentation IDs")
    val segments: Map<SegmentationId, SegmentId>
) {
    constructor(
        model: AccountSpaceModel,
        locale: Locale
    ) : this(
        name = Locales.select(model.nameEn, model.nameRu, locale),
        segments = model.segments.associate { s -> s.segmentationId to s.segmentId }
    )
}
