package ru.yandex.intranet.d.web.model.dictionaries

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.model.folders.FolderModel

@Schema(description = "Folder")
@JsonIgnoreProperties(ignoreUnknown = true)
data class FrontFolderDictionaryElementDto @JsonCreator constructor(
    @get:Schema(description = "Folder name", nullable = false)
    val name: String,
    @get:Schema(description = "Service id", nullable = false)
    val serviceId: String
) {
    constructor(model: FolderModel) : this(
        name = model.displayName,
        serviceId = model.serviceId.toString()
    )
}
