package ru.yandex.intranet.d.web.model.dictionaries

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.i18n.Locales
import ru.yandex.intranet.d.model.providers.ProviderModel
import java.util.Locale

@Schema(description = "Provider")
@JsonIgnoreProperties(ignoreUnknown = true)
data class FrontProviderDictionaryElementDto @JsonCreator constructor(
    @get:Schema(description = "Provider name", nullable = false)
    val name: String
) {
    constructor(model: ProviderModel, locale: Locale) : this(
        name = Locales.select(model.nameEn, model.nameRu, locale)
    )
}
