package ru.yandex.intranet.d.web.model.dictionaries

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.i18n.Locales
import ru.yandex.intranet.d.kotlin.AccountsSpacesId
import ru.yandex.intranet.d.kotlin.ProviderId
import ru.yandex.intranet.d.kotlin.ResourceTypeId
import ru.yandex.intranet.d.kotlin.SegmentId
import ru.yandex.intranet.d.kotlin.SegmentationId
import ru.yandex.intranet.d.model.resources.ResourceModel
import java.util.Locale

@JsonIgnoreProperties(ignoreUnknown = true)
@Schema(description = "Resource")
data class FrontResourceDictionaryElementDto @JsonCreator constructor(
    @get:Schema(description = "Resource's name")
    val name: String,

    @get:Schema(description = "Resource's provider ID")
    val providerId: ProviderId,

    @get:Schema(description = "Resource's type ID")
    val resourceTypeId: ResourceTypeId,

    @get:Schema(description = "Resource's accounts' space ID (if supported)")
    val accountsSpacesId: AccountsSpacesId?,

    @get:Schema(description = "Resource's segment IDs by segmentation IDs")
    val segments: Map<SegmentationId, SegmentId>?
) {
    constructor(
        model: ResourceModel,
        locale: Locale
    ) : this(
        name = Locales.select(model.nameEn, model.nameRu, locale),
        providerId = model.providerId,
        resourceTypeId = model.resourceTypeId,
        accountsSpacesId = model.accountsSpacesId,
        segments = model.segments.associate { s -> s.segmentationId to s.segmentId }
    )
}
