package ru.yandex.intranet.d.web.model.dictionaries

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.i18n.Locales
import ru.yandex.intranet.d.model.resources.segments.ResourceSegmentModel
import java.util.*

@Schema(description = "Resource segment")
@JsonIgnoreProperties(ignoreUnknown = true)
data class FrontResourceSegmentDictionaryElementDto @JsonCreator constructor(
    @get:Schema(description = "Resource segment's name")
    val name: String
) {
    constructor(
        model: ResourceSegmentModel,
        locale: Locale
    ) : this(
        name = Locales.select(model.nameEn, model.nameRu, locale)
    )
}
