package ru.yandex.intranet.d.web.model.dictionaries

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.i18n.Locales
import ru.yandex.intranet.d.model.resources.segmentations.ResourceSegmentationModel
import java.util.*

@Schema(description = "Resource segmentation.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class FrontResourceSegmentationDictionaryElementDto @JsonCreator constructor(
    @get:Schema(description = "Resource segmentation's name")
    val name: String,

    @get:Schema(description = "Resource segmentations' grouping order")
    val groupingOrder: Int
) {
    constructor(
        model: ResourceSegmentationModel,
        locale: Locale
    ) : this(
        name = Locales.select(model.nameEn, model.nameRu, locale),
        groupingOrder = model.groupingOrder
    )
}
