package ru.yandex.intranet.d.web.model.dictionaries

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.i18n.Locales
import ru.yandex.intranet.d.model.resources.types.ResourceTypeModel
import java.util.Locale

@Schema(description = "Resource type")
@JsonIgnoreProperties(ignoreUnknown = true)
data class FrontResourceTypeDictionaryElementDto @JsonCreator constructor(
    @get:Schema(description = "Resource type's name")
    val name: String
) {
    constructor(
        model: ResourceTypeModel,
        locale: Locale
    ) : this(
        name = Locales.select(model.nameEn, model.nameRu, locale)
    )
}
