package ru.yandex.intranet.d.web.model.dictionaries

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.i18n.Locales
import ru.yandex.intranet.d.model.services.ServiceMinimalModel
import java.util.*

@Schema(description = "Service")
@JsonIgnoreProperties(ignoreUnknown = true)
data class FrontServiceDictionaryElementDto @JsonCreator constructor(
    @get:Schema(description = "Service key.", nullable = false)
    val key: String,
    @get:Schema(description = "Service name.", nullable = false)
    val name: String
) {
    constructor(model: ServiceMinimalModel, locale: Locale) : this(
        key = model.slug,
        name = Locales.select(model.nameEn, model.name, locale)
    )
}
