package ru.yandex.intranet.d.web.model.dictionaries;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Frontend unit dictionary element DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Unit of measure.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class FrontUnitDictionaryElementDto {

    private final String shortName;

    @JsonCreator
    public FrontUnitDictionaryElementDto(@JsonProperty("shortName") String shortName) {
        this.shortName = shortName;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Schema(description = "Short name.", required = true)
    public String getShortName() {
        return shortName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FrontUnitDictionaryElementDto that = (FrontUnitDictionaryElementDto) o;
        return Objects.equals(shortName, that.shortName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(shortName);
    }

    @Override
    public String toString() {
        return "FrontUnitDictionaryElementDto{" +
                "shortName='" + shortName + '\'' +
                '}';
    }

    public static final class Builder {

        private String shortName;

        private Builder() {
        }

        public Builder shortName(String shortName) {
            this.shortName = shortName;
            return this;
        }

        public FrontUnitDictionaryElementDto build() {
            Preconditions.checkNotNull(shortName, "ShortName is required");
            return new FrontUnitDictionaryElementDto(shortName);
        }

    }

}
