package ru.yandex.intranet.d.web.model.dictionaries

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.i18n.Locales
import ru.yandex.intranet.d.model.users.UserModel
import java.util.Locale

@Schema(description = "User")
@JsonIgnoreProperties(ignoreUnknown = true)
data class FrontUserDictionaryElementDto @JsonCreator constructor(
    @get:Schema(description = "Passport uid", nullable = false)
    val passportUid: String,
    @get:Schema(description = "Passport login", nullable = false)
    val passportLogin: String,
    @get:Schema(description = "First name", nullable = false)
    val firstName: String,
    @get:Schema(description = "Last name", nullable = false)
    val lastName: String,
    @get:Schema(description = "Gender", nullable = false)
    val gender: String
) {
    constructor(model: UserModel, locale: Locale) : this(
        passportUid = model.passportUid.orElseThrow { IllegalArgumentException("PassportUid is required") },
        passportLogin = model.passportLogin.orElseThrow { IllegalArgumentException("PassportLogin is required") },
        firstName = Locales.select(model.firstNameEn, model.firstNameRu, locale),
        lastName = Locales.select(model.lastNameEn, model.lastNameRu, locale),
        gender = model.gender
    )
}
