package ru.yandex.intranet.d.web.model.folders;

import java.util.Optional;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

import ru.yandex.intranet.d.web.model.accounts.AccountReserveTypeInputDto;

/**
 * Front account input DTO
 *
 * @author Denis Blokhin <denblo@yandex-team.ru>
 */
@Schema(description = "Account input parameters")
@JsonIgnoreProperties(ignoreUnknown = true)
public class FrontAccountInputDto {
    private final String folderId;
    private final String providerId;
    @Nullable
    private final String accountName;
    @Nullable
    private final String accountKey;
    @Nullable
    private final String accountsSpaceId;
    @Nullable
    private final Boolean freeTier;
    @Nullable
    private final AccountReserveTypeInputDto reserveType;

    @JsonCreator
    public FrontAccountInputDto(@JsonProperty("folderId") String folderId,
                                @JsonProperty("providerId") String providerId,
                                @JsonProperty("accountName") @Nullable String accountName,
                                @JsonProperty("accountKey") @Nullable String accountKey,
                                @JsonProperty("accountsSpaceId") @Nullable String accountsSpaceId,
                                @JsonProperty("freeTier") @Nullable Boolean freeTier,
                                @JsonProperty("reserveType") @Nullable AccountReserveTypeInputDto reserveType) {
        this.folderId = folderId;
        this.providerId = providerId;
        this.accountName = accountName;
        this.accountKey = accountKey;
        this.accountsSpaceId = accountsSpaceId;
        this.freeTier = freeTier;
        this.reserveType = reserveType;
    }

    @Schema(description = "Folder identity by string id", required = true)
    public String getFolderId() {
        return folderId;
    }

    @Schema(description = "Provider identity by string id", required = true)
    public String getProviderId() {
        return providerId;
    }

    @Nullable
    @Schema(description = "Account name, if available")
    public String getAccountName() {
        return accountName;
    }

    @Nullable
    @Schema(description = "Account key, if available")
    public String getAccountKey() {
        return accountKey;
    }

    @Nullable
    @Schema(description = "Accounts space identity by string id")
    public String getAccountsSpaceId() {
        return accountsSpaceId;
    }

    @Nullable
    @Schema(description = "'Free tier' account flag")
    public Boolean getFreeTier() {
        return freeTier;
    }

    @Schema(description = "Reserve type.")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<AccountReserveTypeInputDto> getReserveType() {
        return Optional.ofNullable(reserveType);
    }
}
