package ru.yandex.intranet.d.web.model.folders

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.web.model.AccountDto
import ru.yandex.intranet.d.web.model.accounts.AccountOperationStatusDto

@Schema(description = "Account operation result")
@JsonIgnoreProperties(ignoreUnknown = true)
data class FrontAccountOperationDto(
    @get:Schema(description = "Operation status.", required = true)
    val operationStatus: AccountOperationStatusDto,
    @get:Schema(description = "Account.")
    val result: AccountDto?,
    @get:Schema(description = "Operation id.")
    val operationId: String
)
