package ru.yandex.intranet.d.web.model.folders;

import java.math.BigDecimal;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

import ru.yandex.intranet.d.web.model.AmountDto;

/**
 * Amounts (quotas, etc) DTO for front API.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 17.11.2020
 */
@Schema(description = "Quota amounts.")
@JsonIgnoreProperties(ignoreUnknown = true)
public class FrontAmountsDto {
    private final AmountDto quota;
    private final AmountDto balance;
    private final AmountDto positiveBalance;
    private final AmountDto negativeBalance;
    private final AmountDto frozenQuota;
    private final AmountDto provided;
    private final BigDecimal providedRatio;
    private final AmountDto allocated;
    private final BigDecimal allocatedRatio;

    @SuppressWarnings("checkstyle:ParameterNumber")
    @JsonCreator
    public FrontAmountsDto(
            AmountDto quota,
            AmountDto balance,
            AmountDto positiveBalance,
            AmountDto negativeBalance,
            AmountDto frozenQuota,
            AmountDto provided,
            BigDecimal providedRatio,
            AmountDto allocated,
            BigDecimal allocatedRatio
    ) {
        this.quota = quota;
        this.balance = balance;
        this.positiveBalance = positiveBalance;
        this.negativeBalance = negativeBalance;
        this.frozenQuota = frozenQuota;
        this.provided = provided;
        this.allocated = allocated;
        this.allocatedRatio = allocatedRatio;
        this.providedRatio = providedRatio;
    }

    @Schema(description = "Total quota of resource.", required = true)
    public AmountDto getQuota() {
        return quota;
    }

    @Schema(description = "The balance. Free (not provided) quota. Total quota minus provided sum.", required = true)
    public AmountDto getBalance() {
        return balance;
    }

    @Schema(description = "For aggregated balance, sum of positive balances of aggregated resources.", required = true)
    public AmountDto getPositiveBalance() {
        return positiveBalance;
    }

    @Schema(description = "For aggregated balance, sum of negative balances of aggregated resources.", required = true)
    public AmountDto getNegativeBalance() {
        return negativeBalance;
    }

    @Schema(description = "For aggregated frozen quota, sum of frozen quota of aggregated resources.", required = true)
    public AmountDto getFrozenQuota() {
        return frozenQuota;
    }

    @Schema(description = "Sum of provided to accounts quotas.", required = true)
    public AmountDto getProvided() {
        return provided;
    }

    @Schema(description = "Provided quotas sum divide total quota.", required = true)
    public BigDecimal getProvidedRatio() {
        return providedRatio;
    }

    @Schema(description = "Sum of allocated in accounts quotas.", required = true)
    public AmountDto getAllocated() {
        return allocated;
    }

    @Schema(description = "Allocated quotas sum divide provided quotas sum.", required = true)
    public BigDecimal getAllocatedRatio() {
        return allocatedRatio;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FrontAmountsDto that = (FrontAmountsDto) o;
        return Objects.equals(quota, that.quota) &&
                Objects.equals(balance, that.balance) &&
                Objects.equals(positiveBalance, that.positiveBalance) &&
                Objects.equals(negativeBalance, that.negativeBalance) &&
                Objects.equals(frozenQuota, that.frozenQuota) &&
                Objects.equals(provided, that.provided) &&
                Objects.equals(providedRatio, that.providedRatio) &&
                Objects.equals(allocated, that.allocated) &&
                Objects.equals(allocatedRatio, that.allocatedRatio);
    }

    @Override
    public int hashCode() {
        return Objects.hash(quota, balance, positiveBalance, negativeBalance, frozenQuota, provided, providedRatio,
                allocated, allocatedRatio);
    }

    @Override
    public String toString() {
        return "FrontAmountsDto{" +
                "quota=" + quota +
                ", balance=" + balance +
                ", positiveBalance=" + positiveBalance +
                ", negativeBalance=" + negativeBalance +
                ", frozenQuota=" + frozenQuota +
                ", provided=" + provided +
                ", providedRatio=" + providedRatio +
                ", allocated=" + allocated +
                ", allocatedRatio=" + allocatedRatio +
                '}';
    }
}
