package ru.yandex.intranet.d.web.model.folders;

import java.util.Objects;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Frontend folder input DTO.
 *
 * @author Nikita Minin <spasitel@yandex-team.ru>
 */
@Schema(description = "Folder.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class FrontFolderInputDto {

    private final long version;
    private final long serviceId;
    private final String displayName;
    private final String description;
    private final Set<String> tags;

    @JsonCreator
    public FrontFolderInputDto(
            @JsonProperty("version") long version,
            @JsonProperty("serviceId") long serviceId,
            @JsonProperty("displayName") String displayName,
            @JsonProperty("description") String description,
            @JsonProperty("tags") Set<String> tags
    ) {
        this.version = version;
        this.serviceId = serviceId;
        this.displayName = displayName;
        this.description = description;
        this.tags = tags;
    }

    @Schema(description = "Service id.", required = true)
    public long getServiceId() {
        return serviceId;
    }

    @Schema(description = "Display name.", required = true)
    public String getDisplayName() {
        return displayName;
    }

    @Schema(description = "Description.", required = true)
    public String getDescription() {
        return description;
    }

    @Schema(description = "Tags.", required = true)
    public Set<String> getTags() {
        return tags;
    }

    @Schema(description = "Version.", required = true)
    public long getVersion() {
        return version;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FrontFolderInputDto that = (FrontFolderInputDto) o;
        return version == that.version &&
                serviceId == that.serviceId &&
                Objects.equals(displayName, that.displayName) &&
                Objects.equals(description, that.description) &&
                Objects.equals(tags, that.tags);
    }

    @Override
    public int hashCode() {
        return Objects.hash(version, serviceId, displayName, description, tags);
    }

    @Override
    public String toString() {
        return "FolderInputDto{" +
                "version=" + version +
                ", serviceId=" + serviceId +
                ", displayName='" + displayName + '\'' +
                ", description='" + description + '\'' +
                ", tags=" + tags +
                '}';
    }
}
