package ru.yandex.intranet.d.web.model.folders;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

import ru.yandex.intranet.d.web.model.ProviderDto;
import ru.yandex.intranet.d.web.model.ResourceDto;
import ru.yandex.intranet.d.web.model.folders.front.ExpandedFolder;
import ru.yandex.intranet.d.web.model.folders.front.ResourceTypeDto;
import ru.yandex.intranet.d.web.model.resources.AccountsSpaceDto;

/**
 * Response for main page
 *
 * @author Nikita Minin <spasitel@yandex-team.ru>
 */
@Schema(description = "Folder with quotes")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class FrontFolderWithQuotesDto {
    private final List<ExpandedFolder> folders;
    private final List<ResourceDto> resources;
    private final List<ProviderDto> providers;
    private final List<ResourceTypeDto> resourceTypes;
    private final List<AccountsSpaceDto> accountsSpaces;
    private final String continuationToken;

    public FrontFolderWithQuotesDto(List<ExpandedFolder> folders,
                                    List<ResourceDto> resources,
                                    List<ProviderDto> providers,
                                    List<ResourceTypeDto> resourceTypes,
                                    List<AccountsSpaceDto> accountsSpaces,
                                    String continuationToken) {
        this.folders = folders;
        this.resources = resources;
        this.providers = providers;
        this.resourceTypes = resourceTypes;
        this.accountsSpaces = accountsSpaces;
        this.continuationToken = continuationToken;
    }

    public static FrontFolderWithQuotesDto empty() {
        return new FrontFolderWithQuotesDto(Collections.emptyList(),
                Collections.emptyList(),
                Collections.emptyList(),
                Collections.emptyList(),
                Collections.emptyList(),
                null);
    }

    @Schema(description = "Folders.", required = true)
    public List<ExpandedFolder> getFolders() {
        return folders;
    }

    @Schema(description = "Resources.", required = true)
    public List<ResourceDto> getResources() {
        return resources;
    }

    @Schema(description = "Providers.", required = true)
    public List<ProviderDto> getProviders() {
        return providers;
    }

    @Schema(description = "Resource types.", required = true)
    public List<ResourceTypeDto> getResourceTypes() {
        return resourceTypes;
    }

    @Schema(description = "Accounts spaces.", required = true)
    public List<AccountsSpaceDto> getAccountsSpaces() {
        return accountsSpaces;
    }

    @Schema(description = "Next page token.")
    public String getContinuationToken() {
        return continuationToken;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FrontFolderWithQuotesDto that = (FrontFolderWithQuotesDto) o;
        return Objects.equals(folders, that.folders) &&
                Objects.equals(resources, that.resources) &&
                Objects.equals(providers, that.providers) &&
                Objects.equals(resourceTypes, that.resourceTypes) &&
                Objects.equals(accountsSpaces, that.accountsSpaces) &&
                Objects.equals(continuationToken, that.continuationToken);
    }

    @Override
    public int hashCode() {
        return Objects.hash(folders, resources, providers, resourceTypes, accountsSpaces, continuationToken);
    }

    @Override
    public String toString() {
        return "FrontFolderWithQuotesDto{" +
                "folders=" + folders +
                ", resources=" + resources +
                ", providers=" + providers +
                ", resourceTypes=" + resourceTypes +
                ", accountsSpaces=" + accountsSpaces +
                ", continuationToken='" + continuationToken + '\'' +
                '}';
    }
}
