package ru.yandex.intranet.d.web.model.folders

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.web.model.folders.front.ExpandedAccount

/**
 * Front provider reserve accounts DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Reserve account.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class FrontProviderReserveAccountsDto @JsonCreator constructor(
    @get:Schema(description = "Reserve accounts.")
    val accounts: List<ExpandedAccount>,
    @get:Schema(description = "Id of the service containing provider reserve accounts.")
    val reservesServiceId: Long?
)
