package ru.yandex.intranet.d.web.model.folders

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.web.model.accounts.AccountReserveTypeInputDto

/**
 * Front put account DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Account update parameters")
@JsonIgnoreProperties(ignoreUnknown = true)
data class FrontPutAccountDto @JsonCreator constructor(
    @get:Schema(description = "Reserve type.")
    val reserveType: AccountReserveTypeInputDto?
)
