package ru.yandex.intranet.d.web.model.folders

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.kotlin.ServiceId
import ru.yandex.intranet.d.web.model.ProviderDto
import ru.yandex.intranet.d.web.model.ResourceDto
import ru.yandex.intranet.d.web.model.folders.front.ResourceTypeDto
import ru.yandex.intranet.d.web.model.resources.AccountsSpaceDto
import ru.yandex.intranet.d.web.model.services.ServiceMinimalDto

/**
 * Front reserve accounts DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Reserve accounts.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class FrontReserveAccountsDto @JsonCreator constructor(
    @get:Schema(description = "Reserve accounts by provider id.")
    val providerReserveAccounts: Map<String, FrontProviderReserveAccountsDto>,
    @get:Schema(description = "Service DTO.")
    val services: Map<ServiceId, ServiceMinimalDto>,
    @get:Schema(description = "Providers by id.")
    val providers: Map<String, ProviderDto>,
    @get:Schema(description = "Folders by id.")
    val folders: Map<String, FolderDto>,
    @get:Schema(description = "Accounts spaces by id.")
    val accountSpaces: Map<String, AccountsSpaceDto>,
    @get:Schema(description = "Resource types by id.")
    val resourceTypes: Map<String, ResourceTypeDto>,
    @get:Schema(description = "Resources by id.")
    val resources: Map<String, ResourceDto>
)
