package ru.yandex.intranet.d.web.model.folders.front;

import java.util.List;
import java.util.Map;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;

import ru.yandex.intranet.d.web.model.AccountDto;

/**
 * ExpandedAccount.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 18.11.2020
 */
@Schema(description = "Account with resource quotas.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ExpandedAccount {
    private final AccountDto account;
    private final List<ExpandedAccountResource> resources;
    private final Map<String, String> externalAccountUrls;
    private final Boolean urlsForSegments;

    @JsonCreator
    public ExpandedAccount(
            AccountDto account,
            List<ExpandedAccountResource> resources,
            Map<String, String> externalAccountUrls,
            Boolean urlsForSegments
    ) {
        this.account = account;
        this.resources = resources;
        this.externalAccountUrls = externalAccountUrls;
        this.urlsForSegments = urlsForSegments;
    }

    @Schema(description = "Account.", required = true)
    public AccountDto getAccount() {
        return account;
    }

    @Schema(description = "Resources.", required = true)
    public List<ExpandedAccountResource> getResources() {
        return resources;
    }

    @Schema(description = "Urls to account in different UIs and their names.")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Map<String, String> getExternalAccountUrls() {
        return externalAccountUrls;
    }

    @Schema(description = "True if there are different links for different segments.")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Boolean getUrlsForSegments() {
        return urlsForSegments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ExpandedAccount that = (ExpandedAccount) o;
        return Objects.equals(account, that.account) &&
                Objects.equals(resources, that.resources) &&
                Objects.equals(externalAccountUrls, that.externalAccountUrls) &&
                Objects.equals(urlsForSegments, that.urlsForSegments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(account, resources, externalAccountUrls, urlsForSegments);
    }

    @Override
    public String toString() {
        return "ExpandedAccount{" +
                "account=" + account +
                ", resources=" + resources +
                ", externalAccountUrls=" + externalAccountUrls +
                ", urlsForSegments=" + urlsForSegments +
                '}';
    }
}
