package ru.yandex.intranet.d.web.model.folders.front;

import java.util.List;
import java.util.Objects;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

import ru.yandex.intranet.d.web.model.folders.FrontFolderDto;

/**
 * ExpandedFolder.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 18.11.2020
 */
@Schema(description = "Folder with quotas and accounts.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ExpandedFolder {
    private final FrontFolderDto folder;
    private final List<ExpandedProvider> providers;
    private final Set<FolderPermission> permissions;

    public ExpandedFolder(
            FrontFolderDto folder,
            List<ExpandedProvider> providers,
            Set<FolderPermission> permissions) {
        this.folder = folder;
        this.providers = providers;
        this.permissions = permissions;
    }

    @Schema(description = "Folder.", required = true)
    public FrontFolderDto getFolder() {
        return folder;
    }

    @Schema(description = "Folder quotas and accounts per provider.", required = true)
    public List<ExpandedProvider> getProviders() {
        return providers;
    }

    @Schema(description = "Permissions.", required = true)
    public Set<FolderPermission> getPermissions() {
        return permissions;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ExpandedFolder that = (ExpandedFolder) o;
        return Objects.equals(folder, that.folder) &&
                Objects.equals(providers, that.providers) &&
                Objects.equals(permissions, that.permissions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(folder, providers, permissions);
    }

    @Override
    public String toString() {
        return "ExpandedFolder{" +
                "folder=" + folder +
                ", providers=" + providers +
                ", permissions=" + permissions +
                '}';
    }
}
