package ru.yandex.intranet.d.web.model.folders.front;

import java.util.List;
import java.util.Objects;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * ExpandedProvider.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 18.11.2020
 */
@Schema(description = "Quotas and accounts for provider.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ExpandedProvider {
    private final String providerId;
    private final List<ExpandedResourceType> resourceTypes;
    private final List<ExpandedAccount> accounts;
    private final Set<ProviderPermission> permissions;

    @JsonCreator
    public ExpandedProvider(
            String providerId,
            List<ExpandedResourceType> resourceTypes,
            List<ExpandedAccount> expandedAccounts,
            Set<ProviderPermission> permissions
    ) {
        this.providerId = providerId;
        this.resourceTypes = resourceTypes;
        this.accounts = expandedAccounts;
        this.permissions = permissions;
    }

    @Schema(description = "Provider id.", required = true)
    public String getProviderId() {
        return providerId;
    }

    @Schema(description = "Accounts with quotas.", required = true)
    public List<ExpandedAccount> getAccounts() {
        return accounts;
    }

    @Schema(description = "Quotas by resource types.", required = true)
    public List<ExpandedResourceType> getResourceTypes() {
        return resourceTypes;
    }

    @Schema(description = "Permissions for this provider", required = true)
    public Set<ProviderPermission> getPermissions() {
        return permissions;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ExpandedProvider that = (ExpandedProvider) o;
        return Objects.equals(providerId, that.providerId) &&
                Objects.equals(resourceTypes, that.resourceTypes) &&
                Objects.equals(accounts, that.accounts) &&
                Objects.equals(permissions, that.permissions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(providerId, resourceTypes, accounts, permissions);
    }

    @Override
    public String toString() {
        return "ExpandedProvider{" +
                "providerId='" + providerId + '\'' +
                ", resourceTypes=" + resourceTypes +
                ", accounts=" + accounts +
                ", permissions=" + permissions +
                '}';
    }
}
