package ru.yandex.intranet.d.web.model.folders.front;

import java.math.BigDecimal;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

import ru.yandex.intranet.d.web.model.AmountDto;
import ru.yandex.intranet.d.web.model.folders.FrontAmountsDto;

/**
 * ExpandedResource.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 18.11.2020
 */
@Schema(description = "Resource quota.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ExpandedResource extends FrontAmountsDto {
    private final String resourceId;
    private final AmountDto providedAndNotAllocated;

    @SuppressWarnings("checkstyle:ParameterNumber")
    @JsonCreator
    public ExpandedResource(
            String resourceId,
            AmountDto quota,
            AmountDto balance,
            AmountDto positiveBalance,
            AmountDto negativeBalance,
            AmountDto frozenQuota,
            AmountDto provided,
            BigDecimal providedRatio,
            AmountDto allocated,
            BigDecimal allocatedRatio,
            AmountDto providedAndNotAllocated
    ) {
        super(quota, balance, positiveBalance, negativeBalance, frozenQuota, provided, providedRatio, allocated,
                allocatedRatio);
        this.resourceId = resourceId;
        this.providedAndNotAllocated = providedAndNotAllocated;
    }

    @Schema(description = "Resource id.", required = true)
    public String getResourceId() {
        return resourceId;
    }

    @Schema(description = "Provided and not allocated to account quota.", required = true)
    public AmountDto getProvidedAndNotAllocated() {
        return providedAndNotAllocated;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExpandedResource that = (ExpandedResource) o;
        return Objects.equals(resourceId, that.resourceId) && Objects.equals(providedAndNotAllocated,
                that.providedAndNotAllocated);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), resourceId, providedAndNotAllocated);
    }

    @Override
    public String toString() {
        return "ExpandedResource{" +
                "resourceId='" + resourceId + '\'' +
                ", providedAndNotAllocated=" + providedAndNotAllocated +
                "} " + super.toString();
    }
}
