package ru.yandex.intranet.d.web.model.folders.front;

import java.math.BigDecimal;

import ru.yandex.intranet.d.web.model.AmountDto;

public class ExpandedResourceBuilder {
    private String resourceId;
    private AmountDto quota;
    private AmountDto balance;
    private AmountDto positiveBalance;
    private AmountDto negativeBalance;
    private AmountDto frozenQuota;
    private AmountDto provided;
    private BigDecimal providedRatio;
    private AmountDto allocated;
    private BigDecimal allocatedRatio;
    private AmountDto providedAndNotAllocated;

    public ExpandedResourceBuilder setResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public ExpandedResourceBuilder setQuota(AmountDto quota) {
        this.quota = quota;
        return this;
    }

    public ExpandedResourceBuilder setBalance(AmountDto balance) {
        this.balance = balance;
        return this;
    }

    public ExpandedResourceBuilder setPositiveBalance(AmountDto positiveBalance) {
        this.positiveBalance = positiveBalance;
        return this;
    }

    public ExpandedResourceBuilder setNegativeBalance(AmountDto negativeBalance) {
        this.negativeBalance = negativeBalance;
        return this;
    }

    public ExpandedResourceBuilder setFrozenQuota(AmountDto frozenQuota) {
        this.frozenQuota = frozenQuota;
        return this;
    }

    public ExpandedResourceBuilder setProvided(AmountDto provided) {
        this.provided = provided;
        return this;
    }

    public ExpandedResourceBuilder setProvidedRatio(BigDecimal providedRatio) {
        this.providedRatio = providedRatio;
        return this;
    }

    public ExpandedResourceBuilder setAllocated(AmountDto allocated) {
        this.allocated = allocated;
        return this;
    }

    public ExpandedResourceBuilder setAllocatedRatio(BigDecimal allocatedRatio) {
        this.allocatedRatio = allocatedRatio;
        return this;
    }

    public ExpandedResourceBuilder setProvidedAndNotAllocated(AmountDto providedAndNotAllocated) {
        this.providedAndNotAllocated = providedAndNotAllocated;
        return this;
    }

    public ExpandedResource buildExpandedResource() {
        return new ExpandedResource(
                resourceId,
                quota,
                balance,
                positiveBalance,
                negativeBalance,
                frozenQuota,
                provided,
                providedRatio,
                allocated,
                allocatedRatio,
                providedAndNotAllocated
        );
    }

    public ExpandedAccountResource buildExpandedAccountResource() {
        return new ExpandedAccountResource(
                resourceId,
                provided,
                providedRatio,
                allocated,
                allocatedRatio,
                providedAndNotAllocated
        );
    }
}
