package ru.yandex.intranet.d.web.model.folders.front;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

import ru.yandex.intranet.d.web.model.folders.FrontAmountsDto;

/**
 * ExpandedResourceTypeDto.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 18.11.2020
 */
@Schema(description = "Quotas for resource type.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ExpandedResourceType {

    private final String resourceTypeId;
    private final List<ExpandedResource> resources;
    private final FrontAmountsDto sums;

    @JsonCreator
    public ExpandedResourceType(
            String resourceTypeId,
            List<ExpandedResource> resources,
            FrontAmountsDto sums
    ) {
        this.resourceTypeId = resourceTypeId;
        this.resources = resources;
        this.sums = sums;
    }

    @Schema(description = "Resource type id.", required = true)
    public String getResourceTypeId() {
        return resourceTypeId;
    }

    @Schema(description = "Quotas for resource type.", required = true)
    public List<ExpandedResource> getResources() {
        return resources;
    }

    @Schema(description = "Aggregated quotas.", required = true)
    public FrontAmountsDto getSums() {
        return sums;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ExpandedResourceType that = (ExpandedResourceType) o;
        return Objects.equals(resourceTypeId, that.resourceTypeId) &&
                Objects.equals(resources, that.resources) &&
                Objects.equals(sums, that.sums);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceTypeId, resources, sums);
    }

    @Override
    public String toString() {
        return "ExpandedResourceType{" +
                "resourceTypeId='" + resourceTypeId + '\'' +
                ", resources=" + resources +
                ", sums=" + sums +
                '}';
    }
}

