package ru.yandex.intranet.d.web.model.folders.front;

import java.util.Objects;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Resource type DTO for front API.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 18.11.2020
 */
@Schema(description = "Resource type.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ResourceTypeDto {

    private final String id;
    private final String providerId;
    private final String key;
    private final String name;
    private final String description;
    private final String ensemble;
    private final String baseUnit;
    private final Long sortingOrder;

    @SuppressWarnings("ParameterNumber")
    @JsonCreator
    public ResourceTypeDto(
            @JsonProperty("id") String id,
            @JsonProperty("providerId") String providerId,
            @JsonProperty("key") String key,
            @JsonProperty("name") String name,
            @JsonProperty("description") String description,
            @JsonProperty("ensemble") String ensemble,
            @JsonProperty("baseUnit") String baseUnit,
            @JsonProperty("sortingOrder") Long sortingOrder
    ) {
        this.id = id;
        this.providerId = providerId;
        this.ensemble = ensemble;
        this.key = key;
        this.baseUnit = baseUnit;
        this.name = name;
        this.description = description;
        this.sortingOrder = sortingOrder;
    }

    @Schema(description = "Id.", required = true)
    public String getId() {
        return id;
    }

    @Schema(description = "Provider id.", required = true)
    public String getProviderId() {
        return providerId;
    }

    @Schema(description = "Key.", required = true)
    public String getKey() {
        return key;
    }

    @Schema(description = "Name.", required = true)
    public String getName() {
        return name;
    }

    @Schema(description = "Description.", required = true)
    public String getDescription() {
        return description;
    }

    @Schema(description = "Units ensemble name.", required = true)
    public String getEnsemble() {
        return ensemble;
    }

    @Schema(description = "Base unit key.", required = true)
    public String getBaseUnit() {
        return baseUnit;
    }

    @Nullable
    @Schema(description = "Sorting order.")
    public Long getSortingOrder() {
        return sortingOrder;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ResourceTypeDto that = (ResourceTypeDto) o;
        return Objects.equals(id, that.id) &&
                Objects.equals(providerId, that.providerId) &&
                Objects.equals(key, that.key) &&
                Objects.equals(name, that.name) &&
                Objects.equals(description, that.description) &&
                Objects.equals(ensemble, that.ensemble) &&
                Objects.equals(baseUnit, that.baseUnit) &&
                Objects.equals(sortingOrder, that.sortingOrder);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, providerId, key, name, description, ensemble, baseUnit);
    }

    @Override
    public String toString() {
        return "ResourceTypeDto{" +
                "id='" + id + '\'' +
                ", providerId='" + providerId + '\'' +
                ", key='" + key + '\'' +
                ", name='" + name + '\'' +
                ", description='" + description + '\'' +
                ", ensemble='" + ensemble + '\'' +
                ", baseUnit='" + baseUnit + '\'' +
                ", sortingOrder='" + sortingOrder + '\'' +
                '}';
    }
}
