package ru.yandex.intranet.d.web.model.folders.front.history;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

import ru.yandex.intranet.d.web.model.AbcServiceDto;
import ru.yandex.intranet.d.web.model.AccountDto;
import ru.yandex.intranet.d.web.model.PageDto;
import ru.yandex.intranet.d.web.model.ProviderDto;
import ru.yandex.intranet.d.web.model.ResourceDto;
import ru.yandex.intranet.d.web.model.UserDto;
import ru.yandex.intranet.d.web.model.resources.AccountsSpaceDto;

/**
 * Front folder operation log page Dto
 *
 * @author Denis Blokhin <denblo@yandex-team.ru>
 */
@Schema(description = "Folder operations log data.")
@JsonIgnoreProperties(ignoreUnknown = true)
public class FrontFolderOperationLogPageDto {

    private final PageDto<FrontFolderOperationLogDto> page;
    private final Map<String, UserDto> userById;
    private final Map<String, ProviderDto> providerById;
    private final Map<String, ResourceDto> resourcesById;
    private final Map<String, AccountDto> accountsById;
    private final Map<Long, AbcServiceDto> servicesById;
    private final Map<String, AccountsSpaceDto> accountsSpacesById;

    @JsonCreator
    public FrontFolderOperationLogPageDto(PageDto<FrontFolderOperationLogDto> page,
                                          Map<String, UserDto> userById,
                                          Map<String, ProviderDto> providerById,
                                          Map<String, ResourceDto> resourcesById,
                                          Map<String, AccountDto> accountsById,
                                          Map<Long, AbcServiceDto> servicesById,
                                          Map<String, AccountsSpaceDto> accountsSpacesById) {
        this.page = page;
        this.userById = userById;
        this.providerById = providerById;
        this.resourcesById = resourcesById;
        this.accountsById = accountsById;
        this.servicesById = servicesById;
        this.accountsSpacesById = accountsSpacesById;
    }

    @Schema(description = "Folder operations log page.", required = true)
    public PageDto<FrontFolderOperationLogDto> getPage() {
        return page;
    }

    @Schema(description = "Users by id.", required = true)
    public Map<String, UserDto> getUserById() {
        return userById;
    }

    @Schema(description = "Providers by id.", required = true)
    public Map<String, ProviderDto> getProviderById() {
        return providerById;
    }

    @Schema(description = "Resources by id.", required = true)
    public Map<String, ResourceDto> getResourcesById() {
        return resourcesById;
    }

    @Schema(description = "Accounts by id.", required = true)
    public Map<String, AccountDto> getAccountsById() {
        return accountsById;
    }

    @Schema(description = "Services by id.", required = true)
    public Map<Long, AbcServiceDto> getServicesById() {
        return servicesById;
    }

    @Schema(description = "Accounts spaces by id.", required = true)
    public Map<String, AccountsSpaceDto> getAccountsSpacesById() {
        return accountsSpacesById;
    }
}
