package ru.yandex.intranet.d.web.model.idm;

import java.util.Map;
import java.util.Objects;

import com.google.common.collect.ImmutableMap;

import static io.jsonwebtoken.lang.Collections.isEmpty;

public final class IdmUpdate {
    private final String uid;
    private final Map<String, String> roleMap;

    private IdmUpdate(Builder builder) {
        this.uid = builder.uid;
        this.roleMap = ImmutableMap.copyOf(builder.roleMap);

        Objects.requireNonNull(this.uid, "Uid must be provided.");
        if (isEmpty(this.roleMap)) {
            throw new IllegalArgumentException("Role must be provided.");
        }
    }

    public String getUid() {
        return uid;
    }

    public Map<String, String> getRoleMap() {
        return roleMap;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IdmUpdate idmUpdate = (IdmUpdate) o;
        return Objects.equals(uid, idmUpdate.uid) &&
                Objects.equals(roleMap, idmUpdate.roleMap);
    }

    @Override
    public int hashCode() {
        return Objects.hash(uid, roleMap);
    }

    @Override
    public String toString() {
        return "IdmUpdate{" +
                "uid='" + uid + '\'' +
                ", roleMap=" + roleMap +
                '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String uid;
        private Map<String, String> roleMap;

        public Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public Builder roleMap(Map<String, String> roleMap) {
            this.roleMap = roleMap;
            return this;
        }

        public IdmUpdate build() {
            return new IdmUpdate(this);
        }
    }
}
