package ru.yandex.intranet.d.web.model.idm;

import java.util.Objects;

public final class IdmUpdateDto {
    private final String uid;
    private final String role;

    public IdmUpdateDto(String uid, String role) {
        this.uid = uid;
        this.role = role;

        Objects.requireNonNull(this.uid, "Uid must be provided.");
        Objects.requireNonNull(this.role, "Role must be provided.");
    }

    public String getUid() {
        return uid;
    }

    public String getRole() {
        return role;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IdmUpdateDto that = (IdmUpdateDto) o;
        return Objects.equals(uid, that.uid) &&
                Objects.equals(role, that.role);
    }

    @Override
    public int hashCode() {
        return Objects.hash(uid, role);
    }

    @Override
    public String toString() {
        return "IdmUpdateDto{" +
                "uid='" + uid + '\'' +
                ", role='" + role + '\'' +
                '}';
    }
}
