package ru.yandex.intranet.d.web.model.idm;

import java.util.Map;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

public class RoleGroup {
    private final String slug;
    private final String name;
    private final Map<String, String> values;

    private RoleGroup(String slug, String name, Map<String, String> values) {
        this.slug = slug;
        this.name = name;
        this.values = ImmutableMap.copyOf(values);
    }

    public String getSlug() {
        return slug;
    }

    public String getName() {
        return name;
    }

    public Map<String, String> getValues() {
        return values;
    }

    public static RoleGroup.Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String slug;
        private String name;
        private final Map<String, String> values = Maps.newHashMap();

        public Builder slug(String slug) {
            this.slug = slug;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder addRole(String key, String role) {
            values.put(key, role);
            return this;
        }

        public RoleGroup build() {
            return new RoleGroup(slug, name, values);
        }
    }
}
