package ru.yandex.intranet.d.web.model.idm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import ru.yandex.intranet.d.model.users.UserModel;

public class UserRoles {
    private final String uid;
    private final List<Map<String, String>> roles;

    private UserRoles(Builder builder) {
        this.uid = builder.uid;
        this.roles = Collections.unmodifiableList(builder.roles);

        Objects.requireNonNull(uid, "User uid must be provided.");
    }

    public String getUid() {
        return uid;
    }

    public List<Map<String, String>> getRoles() {
        return roles;
    }

    public static UserRoles fromUserModel(UserModel userModel, Map<String, String> role) {
        return builder()
                .uid(userModel.getPassportUid().orElseThrow())
                .addUserRole(role)
                .build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String uid;
        private final List<Map<String, String>> roles = new ArrayList<>();

        public Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public Builder addUserRole(Map<String, String> role) {
            roles.add(Collections.unmodifiableMap(role));
            return this;
        }

        public UserRoles build() {
            return new UserRoles(this);
        }
    }
}
