package ru.yandex.intranet.d.web.model.imports;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Accounts space identity by string id or set of segments.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 24.12.2020
 */
@Schema(description = "Accounts space identity by string id or set of segments.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class AccountSpaceIdentityDto {
    private final String accountSpaceId;
    private final List<SegmentKey> segments;

    @JsonCreator
    public AccountSpaceIdentityDto(String accountSpaceId, List<SegmentKey> segments) {
        this.accountSpaceId = accountSpaceId;
        this.segments = segments;
    }

    @Schema(description = "String ID in ABCD.")
    public String getAccountSpaceId() {
        return accountSpaceId;
    }

    @Schema(description = "Set of provider keys of segments with its segmentations.")
    public List<SegmentKey> getSegments() {
        return segments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountSpaceIdentityDto that = (AccountSpaceIdentityDto) o;
        return Objects.equals(accountSpaceId, that.accountSpaceId) && Objects.equals(segments, that.segments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountSpaceId, segments);
    }

    @Override
    public String toString() {
        return "AccountSpaceIdentityDto{" +
                "accountSpaceId='" + accountSpaceId + '\'' +
                ", segments=" + segments +
                '}';
    }
}
