package ru.yandex.intranet.d.web.model.imports;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Account to import DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Account to import.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImportAccountDto {

    private final String id;
    private final String key;
    private final String displayName;
    private final Boolean deleted;
    private final String providerId;
    private final List<ImportAccountProvisionDto> provisions;
    private final AccountSpaceIdentityDto accountSpaceIdentity;
    private final Boolean freeTier;

    @JsonCreator
    @SuppressWarnings("ParameterNumber")
    public ImportAccountDto(
            @JsonProperty("id") String id,
            @JsonProperty("key") String key,
            @JsonProperty("displayName") String displayName,
            @JsonProperty("deleted") Boolean deleted,
            @JsonProperty("providerId") String providerId,
            @JsonProperty("provisions") List<ImportAccountProvisionDto> provisions,
            AccountSpaceIdentityDto accountSpaceIdentity,
            @JsonProperty("freeTier") Boolean freeTier
    ) {
        this.id = id;
        this.key = key;
        this.displayName = displayName;
        this.deleted = deleted;
        this.providerId = providerId;
        this.provisions = provisions;
        this.accountSpaceIdentity = accountSpaceIdentity;
        this.freeTier = freeTier;
    }

    @Schema(description = "Account id.", required = true)
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @Schema(description = "Account key.")
    public Optional<String> getKey() {
        return Optional.ofNullable(key);
    }

    @Schema(description = "Account display name.")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @Schema(description = "'Account is deleted' flag.")
    public Optional<Boolean> getDeleted() {
        return Optional.ofNullable(deleted);
    }

    @Schema(description = "Provider id.", required = true)
    public Optional<String> getProviderId() {
        return Optional.ofNullable(providerId);
    }

    @Schema(description = "Account provisions.")
    public Optional<List<ImportAccountProvisionDto>> getProvisions() {
        return Optional.ofNullable(provisions);
    }

    @Schema(description = "Account space id.")
    public Optional<AccountSpaceIdentityDto> getAccountSpaceIdentity() {
        return Optional.ofNullable(accountSpaceIdentity);
    }

    @Schema(description = "Free tier flag.")
    @JsonProperty("freeTier")
    public Optional<Boolean> isFreeTier() {
        return Optional.ofNullable(freeTier);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ImportAccountDto that = (ImportAccountDto) o;
        return Objects.equals(id, that.id) &&
                Objects.equals(key, that.key) &&
                Objects.equals(displayName, that.displayName) &&
                Objects.equals(deleted, that.deleted) &&
                Objects.equals(providerId, that.providerId) &&
                Objects.equals(provisions, that.provisions) &&
                Objects.equals(accountSpaceIdentity, that.accountSpaceIdentity) &&
                Objects.equals(freeTier, that.freeTier);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, key, displayName, deleted, providerId, provisions, accountSpaceIdentity, freeTier);
    }

    @Override
    public String toString() {
        return "ImportAccountDto{" +
                "id='" + id + '\'' +
                ", key='" + key + '\'' +
                ", displayName='" + displayName + '\'' +
                ", deleted=" + deleted +
                ", providerId='" + providerId + '\'' +
                ", provisions=" + provisions +
                ", accountSpaceIdentity=" + accountSpaceIdentity +
                ", freeTier=" + freeTier +
                '}';
    }

}
