package ru.yandex.intranet.d.web.model.imports;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Account provision to import DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Account provision to import.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImportAccountProvisionDto {

    private final String resourceId;
    private final ResourceIdentityDto resourceIdentityDto;
    private final Long provided;
    private final String providedUnitKey;
    private final Long allocated;
    private final String allocatedUnitKey;

    @JsonCreator
    public ImportAccountProvisionDto(@JsonProperty("resourceId") String resourceId,
                                     @JsonProperty("resourceIdentity") ResourceIdentityDto resourceIdentityDto,
                                     @JsonProperty("provided") Long provided,
                                     @JsonProperty("providedUnitKey") String providedUnitKey,
                                     @JsonProperty("allocated") Long allocated,
                                     @JsonProperty("allocatedUnitKey") String allocatedUnitKey) {
        this.resourceId = resourceId;
        this.resourceIdentityDto = resourceIdentityDto;
        this.provided = provided;
        this.providedUnitKey = providedUnitKey;
        this.allocated = allocated;
        this.allocatedUnitKey = allocatedUnitKey;
    }

    @Schema(description = "Resource id.")
    public Optional<String> getResourceId() {
        return Optional.ofNullable(resourceId);
    }

    @Schema(description = "Resource identity.")
    public Optional<ResourceIdentityDto> getResourceIdentity() {
        return Optional.ofNullable(resourceIdentityDto);
    }

    @Schema(description = "Provided amount.", required = true)
    public Optional<Long> getProvided() {
        return Optional.ofNullable(provided);
    }

    @Schema(description = "Provided amount unit of measurement key.", required = true)
    public Optional<String> getProvidedUnitKey() {
        return Optional.ofNullable(providedUnitKey);
    }

    @Schema(description = "Allocated amount.", required = true)
    public Optional<Long> getAllocated() {
        return Optional.ofNullable(allocated);
    }

    @Schema(description = "Allocated amount unit of measurement key.", required = true)
    public Optional<String> getAllocatedUnitKey() {
        return Optional.ofNullable(allocatedUnitKey);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ImportAccountProvisionDto that = (ImportAccountProvisionDto) o;
        return Objects.equals(resourceId, that.resourceId) &&
                Objects.equals(resourceIdentityDto, that.resourceIdentityDto) &&
                Objects.equals(provided, that.provided) &&
                Objects.equals(providedUnitKey, that.providedUnitKey) &&
                Objects.equals(allocated, that.allocated) &&
                Objects.equals(allocatedUnitKey, that.allocatedUnitKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceId, resourceIdentityDto, provided, providedUnitKey, allocated, allocatedUnitKey);
    }

    @Override
    public String toString() {
        return "ImportAccountProvisionDto{" +
                "resourceId='" + resourceId + '\'' +
                ", resourceIdentityDto=" + resourceIdentityDto +
                ", provided=" + provided +
                ", providedUnitKey='" + providedUnitKey + '\'' +
                ", allocated=" + allocated +
                ", allocatedUnitKey='" + allocatedUnitKey + '\'' +
                '}';
    }

}
