package ru.yandex.intranet.d.web.model.imports;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Quotas to import DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Quotas to import.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImportDto {

    private final List<ImportFolderDto> quotas;

    @JsonCreator
    public ImportDto(@JsonProperty("quotas") List<ImportFolderDto> quotas) {
        this.quotas = quotas;
    }

    @Schema(description = "Folders quotas to import.", required = true)
    public Optional<List<ImportFolderDto>> getQuotas() {
        return Optional.ofNullable(quotas);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ImportDto importDto = (ImportDto) o;
        return Objects.equals(quotas, importDto.quotas);
    }

    @Override
    public int hashCode() {
        return Objects.hash(quotas);
    }

    @Override
    public String toString() {
        return "ImportDto{" +
                "quotas=" + quotas +
                '}';
    }

}
