package ru.yandex.intranet.d.web.model.imports;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Import failure DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Folder quotas import failure.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImportFailureDto {

    private final String folderId;
    private final Long serviceId;
    private final Set<String> errors;
    private final Map<String, Set<String>> fieldErrors;

    @JsonCreator
    public ImportFailureDto(@JsonProperty("folderId") String folderId,
                            @JsonProperty("serviceId") Long serviceId,
                            @JsonProperty("errors") Set<String> errors,
                            @JsonProperty("fieldErrors") Map<String, Set<String>> fieldErrors) {
        this.folderId = folderId;
        this.serviceId = serviceId;
        this.errors = errors;
        this.fieldErrors = fieldErrors;
    }

    public static ImportFailureDto folder(String folderId, Set<String> errors,
                                          Map<String, Set<String>> fieldErrors) {
        return new ImportFailureDto(folderId, null, errors, fieldErrors);
    }

    public static ImportFailureDto service(long serviceId, Set<String> errors,
                                           Map<String, Set<String>> fieldErrors) {
        return new ImportFailureDto(null, serviceId, errors, fieldErrors);
    }


    @Schema(description = "Folder id.")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<String> getFolderId() {
        return Optional.ofNullable(folderId);
    }

    @Schema(description = "Service id.")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<Long> getServiceId() {
        return Optional.ofNullable(serviceId);
    }

    @Schema(description = "Import errors.", required = true)
    public Set<String> getErrors() {
        return errors;
    }

    @Schema(description = "Import errors per field.", required = true)
    public Map<String, Set<String>> getFieldErrors() {
        return fieldErrors;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ImportFailureDto that = (ImportFailureDto) o;
        return Objects.equals(folderId, that.folderId) &&
                Objects.equals(serviceId, that.serviceId) &&
                Objects.equals(errors, that.errors) &&
                Objects.equals(fieldErrors, that.fieldErrors);
    }

    @Override
    public int hashCode() {
        return Objects.hash(folderId, serviceId, errors, fieldErrors);
    }

    @Override
    public String toString() {
        return "ImportFailureDto{" +
                "folderId='" + folderId + '\'' +
                ", serviceId=" + serviceId +
                ", errors=" + errors +
                ", fieldErrors=" + fieldErrors +
                '}';
    }

}
