package ru.yandex.intranet.d.web.model.imports;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Folder quotas to import DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Folder quotas to import.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImportFolderDto {

    private final String folderId;
    private final Long serviceId;
    private final List<ImportResourceDto> resourceQuotas;
    private final List<ImportAccountDto> accounts;

    @JsonCreator
    public ImportFolderDto(@JsonProperty("folderId") String folderId,
                           @JsonProperty("serviceId") Long serviceId,
                           @JsonProperty("resourceQuotas") List<ImportResourceDto> resourceQuotas,
                           @JsonProperty("accounts") List<ImportAccountDto> accounts) {
        this.folderId = folderId;
        this.serviceId = serviceId;
        this.resourceQuotas = resourceQuotas;
        this.accounts = accounts;
    }

    @Schema(description = "Folder id.")
    public Optional<String> getFolderId() {
        return Optional.ofNullable(folderId);
    }

    @Schema(description = "Service id (default folder of this service will be used).")
    public Optional<Long> getServiceId() {
        return Optional.ofNullable(serviceId);
    }

    @Schema(description = "Folder resource quotas.", required = true)
    public Optional<List<ImportResourceDto>> getResourceQuotas() {
        return Optional.ofNullable(resourceQuotas);
    }

    @Schema(description = "Folders accounts.")
    public Optional<List<ImportAccountDto>> getAccounts() {
        return Optional.ofNullable(accounts);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ImportFolderDto that = (ImportFolderDto) o;
        return Objects.equals(folderId, that.folderId) &&
                Objects.equals(serviceId, that.serviceId) &&
                Objects.equals(resourceQuotas, that.resourceQuotas) &&
                Objects.equals(accounts, that.accounts);
    }

    @Override
    public int hashCode() {
        return Objects.hash(folderId, serviceId, resourceQuotas, accounts);
    }

    @Override
    public String toString() {
        return "ImportFolderDto{" +
                "folderId='" + folderId + '\'' +
                ", serviceId=" + serviceId +
                ", resourceQuotas=" + resourceQuotas +
                ", accounts=" + accounts +
                '}';
    }

}
