package ru.yandex.intranet.d.web.model.imports;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Resource quota to import DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Resource quota to import.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImportResourceDto {

    private final String resourceId;
    private final ResourceIdentityDto resourceIdentityDto;
    private final String providerId;
    private final Long quota;
    private final String quotaUnitKey;
    private final Long balance;
    private final String balanceUnitKey;

    @JsonCreator
    public ImportResourceDto(@JsonProperty("resourceId") String resourceId,
                             @JsonProperty("resourceIdentity") ResourceIdentityDto resourceIdentityDto,
                             @JsonProperty("providerId") String providerId,
                             @JsonProperty("quota") Long quota,
                             @JsonProperty("quotaUnitKey") String quotaUnitKey,
                             @JsonProperty("balance") Long balance,
                             @JsonProperty("balanceUnitKey") String balanceUnitKey) {
        this.resourceId = resourceId;
        this.resourceIdentityDto = resourceIdentityDto;
        this.providerId = providerId;
        this.quota = quota;
        this.quotaUnitKey = quotaUnitKey;
        this.balance = balance;
        this.balanceUnitKey = balanceUnitKey;
    }

    @Schema(description = "Resource id, .")
    public Optional<String> getResourceId() {
        return Optional.ofNullable(resourceId);
    }

    @Schema(description = "Resource identity.")
    public Optional<ResourceIdentityDto> getResourceIdentity() {
        return Optional.ofNullable(resourceIdentityDto);
    }

    @Schema(description = "Provider id.", required = true)
    public Optional<String> getProviderId() {
        return Optional.ofNullable(providerId);
    }

    @Schema(description = "Quota amount.", required = true)
    public Optional<Long> getQuota() {
        return Optional.ofNullable(quota);
    }

    @Schema(description = "Quota amount unit of measurement key.", required = true)
    public Optional<String> getQuotaUnitKey() {
        return Optional.ofNullable(quotaUnitKey);
    }

    @Schema(description = "Balance amount.", required = true)
    public Optional<Long> getBalance() {
        return Optional.ofNullable(balance);
    }

    @Schema(description = "Balance amount unit of measurement key.", required = true)
    public Optional<String> getBalanceUnitKey() {
        return Optional.ofNullable(balanceUnitKey);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ImportResourceDto that = (ImportResourceDto) o;
        return Objects.equals(resourceId, that.resourceId) &&
                Objects.equals(resourceIdentityDto, that.resourceIdentityDto) &&
                Objects.equals(providerId, that.providerId) &&
                Objects.equals(quota, that.quota) &&
                Objects.equals(quotaUnitKey, that.quotaUnitKey) &&
                Objects.equals(balance, that.balance) &&
                Objects.equals(balanceUnitKey, that.balanceUnitKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceId, resourceIdentityDto, providerId, quota, quotaUnitKey, balance, balanceUnitKey);
    }

    @Override
    public String toString() {
        return "ImportResourceDto{" +
                "resourceId='" + resourceId + '\'' +
                ", resourceIdentityDto=" + resourceIdentityDto +
                ", providerId='" + providerId + '\'' +
                ", quota=" + quota +
                ", quotaUnitKey='" + quotaUnitKey + '\'' +
                ", balance=" + balance +
                ", balanceUnitKey='" + balanceUnitKey + '\'' +
                '}';
    }
}
