package ru.yandex.intranet.d.web.model.imports;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Import result DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Import result.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImportResultDto {

    private final List<ImportSuccessKeyDto> successfullyImported;
    private final List<ImportFailureDto> importFailures;

    @JsonCreator
    public ImportResultDto(@JsonProperty("successfullyImported") List<ImportSuccessKeyDto> successfullyImported,
                           @JsonProperty("importFailures") List<ImportFailureDto> importFailures) {
        this.successfullyImported = successfullyImported;
        this.importFailures = importFailures;
    }

    @Schema(description = "Successfully imported resource quotas.", required = true)
    public List<ImportSuccessKeyDto> getSuccessfullyImported() {
        return successfullyImported;
    }

    @Schema(description = "Import failures.", required = true)
    public List<ImportFailureDto> getImportFailures() {
        return importFailures;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ImportResultDto that = (ImportResultDto) o;
        return Objects.equals(successfullyImported, that.successfullyImported) &&
                Objects.equals(importFailures, that.importFailures);
    }

    @Override
    public int hashCode() {
        return Objects.hash(successfullyImported, importFailures);
    }

    @Override
    public String toString() {
        return "ImportResultDto{" +
                "successfullyImported=" + successfullyImported +
                ", importFailures=" + importFailures +
                '}';
    }

}
