package ru.yandex.intranet.d.web.model.imports;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Import success key DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Successfully imported folder quotas key.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImportSuccessKeyDto {

    private final String folderId;
    private final Long serviceId;

    @JsonCreator
    public ImportSuccessKeyDto(@JsonProperty("folderId") String folderId,
                               @JsonProperty("serviceId") Long serviceId) {
        this.folderId = folderId;
        this.serviceId = serviceId;
    }

    public static ImportSuccessKeyDto folder(String folderId) {
        return new ImportSuccessKeyDto(folderId, null);
    }

    public static ImportSuccessKeyDto service(long serviceId) {
        return new ImportSuccessKeyDto(null, serviceId);
    }

    @Schema(description = "Folder id.")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<String> getFolderId() {
        return Optional.ofNullable(folderId);
    }

    @Schema(description = "Service id.")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<Long> getServiceId() {
        return Optional.ofNullable(serviceId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ImportSuccessKeyDto that = (ImportSuccessKeyDto) o;
        return Objects.equals(folderId, that.folderId) &&
                Objects.equals(serviceId, that.serviceId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(folderId, serviceId);
    }

    @Override
    public String toString() {
        return "ImportSuccessKeyDto{" +
                "folderId='" + folderId + '\'' +
                ", serviceId=" + serviceId +
                '}';
    }

}
