package ru.yandex.intranet.d.web.model.imports;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Providers key of segment with its segmentation.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 24.12.2020
 */
@Schema(description = "Providers key of segment with its segmentation.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class SegmentKey {
    private final String segmentationKey;
    private final String segmentKey;

    @JsonCreator
    public SegmentKey(String segmentationKey, String segmentKey) {
        this.segmentationKey = segmentationKey;
        this.segmentKey = segmentKey;
    }

    @Schema(description = "Providers key of used segmentation.")
    public String getSegmentationKey() {
        return segmentationKey;
    }

    @Schema(description = "Providers key of segment.")
    public String getSegmentKey() {
        return segmentKey;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SegmentKey that = (SegmentKey) o;
        return Objects.equals(segmentationKey, that.segmentationKey) && Objects.equals(segmentKey, that.segmentKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(segmentationKey, segmentKey);
    }

    @Override
    public String toString() {
        return "AccountSegmentKey{" +
                "segmentationKey='" + segmentationKey + '\'' +
                ", segmentKey='" + segmentKey + '\'' +
                '}';
    }
}
