package ru.yandex.intranet.d.web.model.legacy

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Service tree node.
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */
@Schema(description = "Services list.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class DispenserGetProjectsListResponseDto @JsonCreator constructor(
    val result: List<DispenserGetProjectsResponseDto>
)

@Schema(description = "Description service.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class DispenserGetProjectsResponseDto @JsonCreator constructor(
    @get:Schema(description = "ABC service slug")
    val key: String,
    @get:Schema(description = "ABC child services")
    val subprojectKeys: List<String>
)

