package ru.yandex.intranet.d.web.model.legacy

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

@Schema(description = "Dispenser compatible API getQuotas response DTO")
@JsonIgnoreProperties(ignoreUnknown = true)
data class DispenserGetQuotasResponseDto @JsonCreator constructor(
    val result: List<DispenserGetQuotasProvisionDto>
)

@Schema(description = "Dispenser compatible API single project's quota")
@JsonIgnoreProperties(ignoreUnknown = true)
data class DispenserGetQuotasProvisionDto @JsonCreator constructor(
    @get:Schema(description = "Quota's key")
    val key: DiQuotaKey,
    val max: Long,
    val actual: Long,
    val ownMax: Long = 0L,
    val ownActual: Long = 0L,
    val lastOverquotingTs: Long? = null
)

@Schema(description = "Dispenser compatible API quota's key")
@JsonIgnoreProperties(ignoreUnknown = true)
data class DiQuotaKey @JsonCreator constructor(
    @get:Schema(description = "ABC service slug")
    val projectKey: String,
    @get:Schema(description = "Provider's key")
    val serviceKey: String,
    @get:Schema(description = "Resource's key")
    val resourceKey: String,
    @get:Schema(description = "Dispenser API compatible resource's quotaSpecKey")
    val quotaSpecKey: String,
    @get:Schema(description = "Resource segment keys")
    val segmentKeys: Set<String> = setOf()
)
