package ru.yandex.intranet.d.web.model.loans

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.kotlin.ProviderId
import ru.yandex.intranet.d.kotlin.UserId
import ru.yandex.intranet.d.model.loans.LoanActionSubject

@JsonIgnoreProperties(ignoreUnknown = true)
@Schema(description = "Loan action subject. Exactly one field must be present.")
data class LoanActionSubjectDto @JsonCreator constructor(
    @get:Schema(description = "The most typical case, authenticated user is present", nullable = true)
    val user: UserId?,

    @get:Schema(
        description = "Not an authenticated user but an authenticated provider," +
            "i.e. only provider TVM service ticket was present",
        nullable = true
    )
    val provider: ProviderId?
) {
    constructor(model: LoanActionSubject) : this(
        user = model.user,
        provider = model.provider
    )
}
