package ru.yandex.intranet.d.web.model.loans

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.model.loans.LoanActionSubjects

@JsonIgnoreProperties(ignoreUnknown = true)
@Schema(description = "Action subjects")
data class LoanActionSubjectsDto @JsonCreator constructor(
    @get:Schema(description = "Action subjects list", nullable = false)
    val subjects: List<LoanActionSubjectDto>
) {
    constructor(model: LoanActionSubjects) : this(
        subjects = model.subjects.map { LoanActionSubjectDto(it) }
    )
}

